using System;
using Server;

namespace Server.Items
{
	public class BrightsightLenses : BaseArmor
	{
		public override int LabelNumber{ get{ return 1075039; } } // Brightsight Lenses
      
      public override int BasePhysicalResistance{ get{ return 9; } }
		public override int BaseFireResistance{ get{ return 29; } }
		public override int BaseColdResistance{ get{ return 7; } }
		public override int BasePoisonResistance{ get{ return 8; } }
		public override int BaseEnergyResistance{ get{ return 7; } }

		public override int InitMinHits{ get{ return 75; } }
		public override int InitMaxHits{ get{ return 75; } }

		public override int AosStrReq{ get{ return 10; } }
		public override int OldStrReq{ get{ return 10; } }

		public override int ArmorBase{ get{ return 25; } }

		public override ArmorMaterialType MaterialType{ get{ return ArmorMaterialType.Chainmail; } }

		public override ArmorMeditationAllowance DefMedAllowance{ get{ return ArmorMeditationAllowance.All; } }

		[Constructable]
		public BrightsightLenses() : base( 0x3172 )
		{
			Weight = 1.0;
			Hue = 149;
         this.Attributes.NightSight = 1;
         this.Attributes.RegenMana = 3;
         this.ArmorAttributes.SelfRepair = 3;
		}

		public BrightsightLenses( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}
		
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}